/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.SimulationParameter;
import DE.siemens.ad.logo.util.DoubleValueProperties;
import java.io.IOException;
import java.io.ObjectInputStream;

public abstract class AbstractInputSimulationParameter
extends SimulationParameter {
    protected double fInternAnalogValue;
    static final long serialVersionUID = -463221659382322844L;
    private int serializedDataVersion = 2;
    protected double fThresholdValue = 10.0;
    protected double fAnalogousValue;
    protected double fSensorGain = 1.0;
    protected double fSensorOffset = 0.0;
    protected double fMaxValue = 10.0;
    protected double fMinValue;
    protected boolean fBinaryValue;
    protected int fSwitchMode;
    protected boolean AutoMeasurementRange = true;
    public static final String SWITCH_MODE_CHANGED = "switchModeChanged";

    public AbstractInputSimulationParameter(Block block) {
        super(block);
    }

    public void addParameterSetListener(ParameterSetListener l) {
        super.addParameterSetListener(l);
    }

    public double getInternAnalogValue() {
        return this.fInternAnalogValue;
    }

    public double getExternAnalogValue() {
        return this.fAnalogousValue;
    }

    public void setInternAnalogValue(double analogValue) {
        this.fAnalogousValue = analogValue;
        this.fInternAnalogValue = analogValue;
        this.fireParameterSetEvent();
    }

    public boolean getBinaryValue() {
        return this.fBinaryValue;
    }

    public DoubleValueProperties getExternAnalogValueProperties() {
        return new DoubleValueProperties(this.getMinValue(), this.getMaxValue(), 1.0, this.getExternAnalogValue(), "-####0", "error.dialog.invalidValue", "Invalid Value");
    }

    protected abstract double getAutoMaxValue();

    protected abstract double getAutoMinValue();

    public abstract int[] getAvailableSwitchModes();

    public double getMaxValue() {
        double max = this.fMaxValue;
        double min = this.fMinValue;
        if (this.isAutoMeasurementRange()) {
            max = this.getAutoMaxValue();
            min = this.getAutoMinValue();
        }
        return Math.max(min, max);
    }

    public abstract DoubleValueProperties getMaxValueProperties();

    public double getMinValue() {
        double min = this.fMinValue;
        double max = this.fMaxValue;
        if (this.isAutoMeasurementRange()) {
            min = this.getAutoMinValue();
            max = this.getAutoMaxValue();
        }
        return Math.min(min, max);
    }

    public abstract DoubleValueProperties getMinValueProperties();

    public abstract int getSwitchMode();

    public double getThresholdValue() {
        return 0.0;
    }

    public boolean isAutoMeasurementRange() {
        return this.AutoMeasurementRange;
    }

    public void removeParameterSetListener(ParameterSetListener l) {
        super.removeParameterSetListener(l);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serializedDataVersion < 2) {
            this.serializedDataVersion = 2;
            this.fSensorGain = 1.0;
            this.fSensorOffset = 0.0;
        }
    }

    public void setExternAnalogValue(double newValue) {
        this.fAnalogousValue = newValue;
        this.fInternAnalogValue = Math.round(newValue * this.fSensorGain + this.fSensorOffset);
        if (this.fSwitchMode == 4 || this.fSwitchMode == 2) {
            this.fBinaryValue = this.fThresholdValue <= this.fAnalogousValue;
        }
        this.fireParameterSetEvent();
    }

    public void setAutoMeasurementRange(boolean newAutoMeasurementRange) {
        this.AutoMeasurementRange = newAutoMeasurementRange;
    }

    public void setMaxValue(double newMaxValue) {
        this.fMaxValue = newMaxValue;
    }

    public void setMinValue(double newMinValue) {
        this.fMinValue = newMinValue;
    }

    public void setSwitchMode(int mode) {
        this.fSwitchMode = mode;
        this.fireParameterSetEvent(SWITCH_MODE_CHANGED);
    }

    public void setThresholdValue(double value) {
        this.fThresholdValue = value;
        this.fBinaryValue = this.fThresholdValue <= this.fAnalogousValue;
    }

    public void setBinaryValue(boolean newValue) {
        this.fBinaryValue = newValue;
        this.fAnalogousValue = this.fBinaryValue ? this.getThresholdValue() : 0.0;
        this.fireParameterSetEvent();
    }
}

